clear all

disp('Data loading and generation...');
ima = double(imread('lena.png'));
sigma = 40;
ima_nse = ima + sigma * randn(size(ima));

disp('Non-it PPB filter...');
hW = 10;
hD = 3;
alpha = 0.88;
T = inf;
nbit = 1;
ima_fil_1 = ppb_gauss(ima_nse, sigma, ...
                      hW, hD, ...
                      alpha, T, ...
                      nbit);

disp('It PPB filter...');
hW = [1 3 5 10];
hD = [0 1 2 3];
alpha = 0.92;
T = 0.2;
nbit = [1 2 3 4];
ima_fil_2 = ppb_gauss(ima_nse, sigma, ...
                      hW, hD, ...
                      alpha, T, ...
                      nbit);

figure
subplot(2,2,1), plotimage(ima);
title('Noise-free image');
subplot(2,2,2), plotimage(ima_nse);
title(sprintf('Noisy image (PSNR %.3f)', psnr(ima_nse, ima, sigma)));
subplot(2,2,3), plotimage(ima_fil_1);
title(sprintf('Non-it PPB filter (PSNR %.3f)', psnr(ima_fil_1, ima, sigma)));
subplot(2,2,4), plotimage(ima_fil_2);
title(sprintf('It PPB filter (PSNR %.3f)', psnr(ima_fil_2, ima, sigma)));

